/*
 * Decompiled with CFR 0.152.
 */
package gong;

import gong.Utility;
import gong.audio.AudioData;
import gong.audio.AudioHandler;
import gong.audio.OlaBuffer;
import gong.audio.data.BlockAudioData;
import gong.audio.data.FlvPCMData;
import gong.audio.data.ImaADPCMData;
import gong.audio.data.SpeexData;
import gong.event.AudioDataListener;
import gong.event.AudioHandlerListener;
import gong.ui.plaf.NanoAmplitudeUI;
import gong.ui.plaf.NanoButtonUI;
import gong.ui.plaf.NanoSpeedButtonUI;
import gong.ui.plaf.NanoTimeUI;
import gong.xml.gasi.Fault;
import gong.xml.gasi.Message;
import gong.xml.gasi.Request;
import gong.xml.gasi.Response;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.math.BigInteger;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.text.DecimalFormat;
import java.text.MessageFormat;
import java.util.Date;
import java.util.ResourceBundle;
import javax.sound.sampled.AudioFormat;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.JApplet;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JSlider;
import javax.swing.SwingUtilities;
import javax.swing.filechooser.FileFilter;

public class NanoGong
extends JApplet
implements AudioDataListener,
AudioHandlerListener,
NanoTimeUI.TimeListener {
    static final String VERSION_NUMBER = "4.2";
    private ResourceBundle bundle;
    static final String IMA_ADPCM = "ImaADPCM";
    static final String SPEEX = "Speex";
    private AudioHandler handler = new AudioHandler();
    private URLLoader currentLoader = null;
    private ScriptHandler currentScriptHandler = null;
    private String scriptError = null;
    private boolean modified = false;
    private String audioFormat = "Speex";
    private float samplingRate = 44100.0f;
    private int speexQuality = 10;
    private long maxDuration = 300000L;
    private JLabel lblTime;
    private JPanel panGlassPane;
    private boolean showTime = false;
    private long startTime = -1L;
    private long endTime = -1L;
    private JButton btnFast;
    private JButton btnPlay;
    private JButton btnRecord;
    private JButton btnSave;
    private JButton btnSlow;
    private JButton btnStop;
    private JLabel lblMessage;
    private JLabel lblSpeed;
    private JPanel panPanel;
    private JPanel panSpeed;
    private JPanel panWait;
    private JProgressBar pbrWait;
    private JSlider slrAmplitude;
    private JSlider slrTime;

    protected synchronized URLLoader getURLLoader(String string, long l, long l2) {
        if (this.currentLoader != null) {
            return null;
        }
        this.currentLoader = new URLLoader(string, l, l2);
        return this.currentLoader;
    }

    protected synchronized void clearURLLoader() {
        this.currentLoader = null;
    }

    protected synchronized ScriptHandler getScriptHandler(String string, String[] stringArray) {
        if (this.currentLoader != null || this.currentScriptHandler != null) {
            return null;
        }
        this.currentScriptHandler = stringArray == null ? new ScriptHandler(string) : new ScriptHandler(string, stringArray);
        return this.currentScriptHandler;
    }

    protected synchronized void clearScriptHandler() {
        this.currentScriptHandler = null;
    }

    private String resolveURL(String string) throws MalformedURLException {
        if (string != null && string.trim().length() > 0) {
            if (string.startsWith("http://")) {
                return new URL(string).toString();
            }
            return new URL(this.getCodeBase(), string).toString();
        }
        return null;
    }

    private String getMessageString(String string) {
        String string2 = this.bundle.getString(string);
        FontMetrics fontMetrics = this.getGraphics().getFontMetrics(this.lblMessage.getFont());
        int n = fontMetrics.stringWidth(string2);
        if (n > this.getWidth() - 20) {
            string2 = this.bundle.getString(string + "_SHORT");
        }
        return string2;
    }

    public void init() {
        int n;
        this.bundle = ResourceBundle.getBundle("gong/i18n/NanoGong");
        try {
            EventQueue.invokeAndWait(new Runnable(){

                public void run() {
                    NanoGong.this.initComponents();
                    NanoGong.this.btnPlay.setUI(new NanoButtonUI("play"));
                    NanoGong.this.btnRecord.setUI(new NanoButtonUI("record"));
                    NanoGong.this.btnStop.setUI(new NanoButtonUI("stop"));
                    NanoGong.this.btnSave.setUI(new NanoButtonUI("save"));
                    NanoGong.this.slrAmplitude.setUI(new NanoAmplitudeUI(NanoGong.this.slrAmplitude));
                    NanoGong.this.btnSlow.setUI(new NanoSpeedButtonUI("slow"));
                    NanoGong.this.btnFast.setUI(new NanoSpeedButtonUI("fast"));
                    NanoGong.this.slrTime.setUI(new NanoTimeUI(NanoGong.this.slrTime, NanoGong.this));
                    NanoGong.this.panWait.setVisible(false);
                    NanoGong.this.lblTime = new JLabel();
                    NanoGong.this.lblTime.setText("");
                    NanoGong.this.lblTime.setBackground(new Color(1.0f, 1.0f, 1.0f, 0.8f));
                    NanoGong.this.lblTime.setBorder(BorderFactory.createLineBorder(Color.WHITE));
                    NanoGong.this.lblTime.setBounds((NanoGong.this.getWidth() - 100) / 2, 20, 100, 12);
                    NanoGong.this.lblTime.setFont(new Font("Dialog", 1, 10));
                    NanoGong.this.lblTime.setHorizontalAlignment(0);
                    NanoGong.this.lblTime.setOpaque(true);
                    NanoGong.this.lblTime.setPreferredSize(NanoGong.this.lblTime.getSize());
                    NanoGong.this.panGlassPane = (JPanel)NanoGong.this.getGlassPane();
                    NanoGong.this.panGlassPane.setLayout(null);
                    NanoGong.this.panGlassPane.add(NanoGong.this.lblTime);
                }
            });
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.handler.addListener(this);
        String string = this.getParameter("ShowAudioLevel");
        if (string != null && string.equalsIgnoreCase("false")) {
            this.slrAmplitude.setVisible(false);
        }
        if ((string = this.getParameter("ShowRecordButton")) != null && string.equalsIgnoreCase("false")) {
            this.btnRecord.setVisible(false);
        }
        if ((string = this.getParameter("ShowSpeedButton")) != null && string.equalsIgnoreCase("false")) {
            this.panSpeed.setVisible(false);
        }
        if ((string = this.getParameter("ShowSaveButton")) != null && string.equalsIgnoreCase("false")) {
            this.btnSave.setVisible(false);
        }
        if ((string = this.getParameter("ShowTime")) != null && string.equalsIgnoreCase("true")) {
            this.showTime = true;
        }
        if ((string = this.getParameter("AudioFormat")) != null && string.equals(IMA_ADPCM)) {
            this.audioFormat = IMA_ADPCM;
        }
        if ((string = this.getParameter("SamplingRate")) != null) {
            try {
                n = Integer.parseInt(string);
                if (this.audioFormat.equals(IMA_ADPCM)) {
                    if (n == 8000 || n == 11025 || n == 22050 || n == 44100) {
                        this.samplingRate = n;
                    }
                } else if (n == 8000 || n == 16000 || n == 32000 || n == 44100) {
                    this.samplingRate = n;
                }
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        if ((string = this.getParameter("SpeexQuality")) != null) {
            try {
                n = Integer.parseInt(string);
                if (n >= 0 && n <= 10) {
                    this.speexQuality = n;
                }
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        if ((string = this.getParameter("Color")) != null && string.length() > 1) {
            try {
                Color color = new Color(Integer.parseInt(string.substring(1), 16));
                this.panPanel.setBackground(color);
                this.btnPlay.setBackground(color);
                this.btnRecord.setBackground(color);
                this.btnStop.setBackground(color);
                this.slrAmplitude.setBackground(color);
                this.panSpeed.setBackground(color);
                this.btnSlow.setBackground(color);
                this.btnFast.setBackground(color);
                this.lblSpeed.setBackground(color);
                this.btnSave.setBackground(color);
                this.slrTime.setBackground(color);
                this.panWait.setBackground(color);
                this.lblMessage.setBackground(color);
                this.pbrWait.setBackground(color);
            }
            catch (NumberFormatException numberFormatException) {
                this.speexQuality = 0;
            }
        }
        if ((string = this.getParameter("MaxDuration")) != null) {
            try {
                long l = Long.parseLong(string);
                if (l > 0L && l <= 1200L) {
                    this.maxDuration = l * 1000L;
                }
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        if ((string = this.getParameter("StartTime")) != null) {
            try {
                double d = Double.parseDouble(string);
                if (d > 0.0) {
                    this.startTime = (long)(d * 1000.0);
                }
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        if ((string = this.getParameter("EndTime")) != null) {
            try {
                double d = Double.parseDouble(string);
                if (d > 0.0) {
                    this.endTime = (long)(d * 1000.0);
                }
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        if (this.startTime > 0L && this.endTime > 0L && this.endTime <= this.startTime) {
            this.endTime = -1L;
        }
        String string2 = this.getParameter("SoundFileURL");
        try {
            string2 = this.resolveURL(string2);
            this.handler.setURL(string2);
        }
        catch (MalformedURLException malformedURLException) {
            this.handler.setURL(null);
        }
        if (string2 != null) {
            URLLoader uRLLoader = this.getURLLoader(string2, this.startTime, this.endTime);
            if (uRLLoader == null) {
                JOptionPane.showMessageDialog(this, "NanoGong is busy at the moment.", "Error", 0);
            } else {
                uRLLoader.start();
            }
        }
    }

    public void timeUpdate(AudioHandler audioHandler, long l) {
        this.slrTime.setValue((int)l);
        this.lblTime.setText(Utility.formatTime(l, false) + " / " + Utility.formatTime(audioHandler.getDuration(), false));
        if (this.panGlassPane.isVisible()) {
            this.panGlassPane.repaint();
        }
    }

    public void statusUpdate(final AudioHandler audioHandler, final int n) {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                NanoGong.this.btnPlay.setEnabled(audioHandler.hasData() && (n == 2 || n == 4 || n == 7 || n == 9));
                if (n == 2) {
                    ((NanoButtonUI)NanoGong.this.btnPlay.getUI()).setIconType("pause");
                    NanoGong.this.btnPlay.setToolTipText(NanoGong.this.bundle.getString("TOOLTIP_PLAY_PAUSE_BUTTON"));
                } else {
                    ((NanoButtonUI)NanoGong.this.btnPlay.getUI()).setIconType("play");
                    NanoGong.this.btnPlay.setToolTipText(NanoGong.this.bundle.getString("TOOLTIP_PLAY_BUTTON"));
                }
                NanoGong.this.btnPlay.repaint();
                NanoGong.this.btnRecord.setEnabled(n == 1 || n == 5 || n == 7 || n == 9);
                if (n == 1) {
                    ((NanoButtonUI)NanoGong.this.btnRecord.getUI()).setIconType("pause");
                    NanoGong.this.btnRecord.setToolTipText(NanoGong.this.bundle.getString("TOOLTIP_RECORD_PAUSE_BUTTON"));
                } else {
                    ((NanoButtonUI)NanoGong.this.btnRecord.getUI()).setIconType("record");
                    NanoGong.this.btnRecord.setToolTipText(NanoGong.this.bundle.getString("TOOLTIP_RECORD_BUTTON"));
                }
                NanoGong.this.btnRecord.repaint();
                NanoGong.this.btnStop.setEnabled(n == 2 || n == 1 || n == 4 || n == 5);
                NanoGong.this.btnSave.setEnabled(audioHandler.hasData() && (n == 7 || n == 9));
                NanoGong.this.slrTime.setEnabled(audioHandler.hasData() && n != 1 && n != 5);
            }
        });
    }

    public void durationUpdate(AudioHandler audioHandler, long l) {
        this.slrTime.setMaximum((int)l);
        this.lblTime.setText(Utility.formatTime(audioHandler.getTime(), false) + " / " + Utility.formatTime(l, false));
        if (this.panGlassPane.isVisible()) {
            this.panGlassPane.repaint();
        }
    }

    public void amplitudeUpdate(AudioHandler audioHandler, float f) {
        this.slrAmplitude.setValue((int)(f * (float)this.slrAmplitude.getMaximum()));
    }

    public void timeUpdate(int n) {
        this.handler.setTime(n);
    }

    public void received(AudioData audioData, long l) {
        if (audioData.isSupported("received-progress")) {
            final int n = (int)(100.0 * (double)l / (double)audioData.getDuration());
            final String string = MessageFormat.format(this.getMessageString("MESSAGE_LOADING_WITH_PROGRESS"), new Integer(n));
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    if (NanoGong.this.pbrWait.isIndeterminate()) {
                        NanoGong.this.pbrWait.setMaximum(100);
                        NanoGong.this.pbrWait.setIndeterminate(false);
                    }
                    NanoGong.this.pbrWait.setValue(n);
                    if (NanoGong.this.panWait.isVisible()) {
                        NanoGong.this.lblMessage.setText(string);
                    }
                }
            });
        }
    }

    public void sent(AudioData audioData, long l) {
        if (audioData.isSupported("sent-progress")) {
            final int n = (int)(100.0 * (double)l / (double)audioData.getDuration());
            final String string = MessageFormat.format(this.getMessageString("MESSAGE_SENDING_WITH_PROGRESS"), new Integer(n));
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    if (NanoGong.this.pbrWait.isIndeterminate()) {
                        NanoGong.this.pbrWait.setMaximum(100);
                        NanoGong.this.pbrWait.setIndeterminate(false);
                    }
                    NanoGong.this.pbrWait.setValue(n);
                    if (NanoGong.this.panWait.isVisible()) {
                        NanoGong.this.lblMessage.setText(string);
                    }
                }
            });
        }
    }

    public void finish(AudioData audioData, long l) {
    }

    public String getAppletInfo() {
        return "NanoGong applet version 4.2 by the Gong Project (http://gong.ust.hk)";
    }

    public String sendGongRequest(String string) {
        return this.processGongRequest(string);
    }

    public String sendGongRequest(String string, String string2) {
        return this.processGongRequest(string, new String[]{string2});
    }

    public String sendGongRequest(String string, String string2, String string3) {
        return this.processGongRequest(string, new String[]{string2, string3});
    }

    public String sendGongRequest(String string, String string2, String string3, String string4) {
        return this.processGongRequest(string, new String[]{string2, string3, string4});
    }

    public String sendGongRequest(String string, String string2, String string3, String string4, String string5) {
        return this.processGongRequest(string, new String[]{string2, string3, string4, string5});
    }

    protected String processGongRequest(String string) {
        ScriptHandler scriptHandler = this.getScriptHandler(string, null);
        if (scriptHandler == null) {
            try {
                Fault fault = Message.newFault("", "NanoGong is busy at the moment.");
                return fault.toString();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        scriptHandler.execute();
        Fault fault = (Fault)scriptHandler.getFault();
        String string2 = fault != null ? fault.toString() : scriptHandler.getResponse().toString();
        this.clearScriptHandler();
        return string2;
    }

    protected String processGongRequest(String string, String[] stringArray) {
        String string2;
        this.scriptError = null;
        if (!Request.isTextRequest(string)) {
            this.scriptError = "You have made an invalid request.";
            return "";
        }
        ScriptHandler scriptHandler = this.getScriptHandler(string, stringArray);
        if (scriptHandler == null) {
            this.scriptError = "NanoGong is busy at the moment.";
            return "";
        }
        scriptHandler.execute();
        Object object = scriptHandler.getFault();
        if (object != null) {
            this.scriptError = object.toString();
            string2 = "";
        } else {
            string2 = scriptHandler.getResponse().toString();
        }
        this.clearScriptHandler();
        return string2;
    }

    public String getError() {
        if (this.scriptError == null) {
            return "";
        }
        return this.scriptError;
    }

    public String getModified() {
        if (this.modified) {
            return "1";
        }
        return "0";
    }

    private void initComponents() {
        this.panPanel = new JPanel();
        this.btnPlay = new JButton();
        this.btnRecord = new JButton();
        this.btnStop = new JButton();
        this.slrAmplitude = new JSlider();
        this.panSpeed = new JPanel();
        this.btnSlow = new JButton();
        this.btnFast = new JButton();
        this.lblSpeed = new JLabel();
        this.btnSave = new JButton();
        this.slrTime = new JSlider();
        this.panWait = new JPanel();
        this.lblMessage = new JLabel();
        this.pbrWait = new JProgressBar();
        this.getContentPane().setLayout(new BoxLayout(this.getContentPane(), 0));
        this.panPanel.setLayout(new GridBagLayout());
        this.panPanel.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        this.btnPlay.setToolTipText(this.bundle.getString("TOOLTIP_PLAY_BUTTON"));
        this.btnPlay.setMaximumSize(new Dimension(25, 25));
        this.btnPlay.setMinimumSize(new Dimension(25, 25));
        this.btnPlay.setPreferredSize(new Dimension(25, 25));
        this.btnPlay.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                NanoGong.this.btnPlayActionPerformed(actionEvent);
            }
        });
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridy = 0;
        this.panPanel.add((Component)this.btnPlay, gridBagConstraints);
        this.btnRecord.setToolTipText(this.bundle.getString("TOOLTIP_RECORD_BUTTON"));
        this.btnRecord.setMaximumSize(new Dimension(25, 25));
        this.btnRecord.setMinimumSize(new Dimension(25, 25));
        this.btnRecord.setPreferredSize(new Dimension(25, 25));
        this.btnRecord.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                NanoGong.this.btnRecordActionPerformed(actionEvent);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridy = 0;
        gridBagConstraints.insets = new Insets(0, 5, 0, 0);
        this.panPanel.add((Component)this.btnRecord, gridBagConstraints);
        this.btnStop.setToolTipText(this.bundle.getString("TOOLTIP_STOP_BUTTON"));
        this.btnStop.setMaximumSize(new Dimension(25, 25));
        this.btnStop.setMinimumSize(new Dimension(25, 25));
        this.btnStop.setPreferredSize(new Dimension(25, 25));
        this.btnStop.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                NanoGong.this.btnStopActionPerformed(actionEvent);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridy = 0;
        gridBagConstraints.insets = new Insets(0, 5, 0, 0);
        this.panPanel.add((Component)this.btnStop, gridBagConstraints);
        this.slrAmplitude.setValue(0);
        this.slrAmplitude.setMaximumSize(new Dimension(15, 25));
        this.slrAmplitude.setMinimumSize(new Dimension(15, 25));
        this.slrAmplitude.setPreferredSize(new Dimension(15, 25));
        this.slrAmplitude.setForeground(Color.GREEN);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridy = 0;
        gridBagConstraints.insets = new Insets(0, 5, 0, 0);
        this.panPanel.add((Component)this.slrAmplitude, gridBagConstraints);
        this.panSpeed.setLayout(new GridBagLayout());
        this.panSpeed.setOpaque(false);
        this.btnSlow.setToolTipText(this.bundle.getString("TOOLTIP_SLOW_BUTTON"));
        this.btnSlow.setMaximumSize(new Dimension(15, 15));
        this.btnSlow.setMinimumSize(new Dimension(15, 15));
        this.btnSlow.setPreferredSize(new Dimension(15, 15));
        this.btnSlow.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                NanoGong.this.btnSlowActionPerformed(actionEvent);
            }
        });
        this.panSpeed.add((Component)this.btnSlow, new GridBagConstraints());
        this.btnFast.setToolTipText(this.bundle.getString("TOOLTIP_FAST_BUTTON"));
        this.btnFast.setMaximumSize(new Dimension(15, 15));
        this.btnFast.setMinimumSize(new Dimension(15, 15));
        this.btnFast.setPreferredSize(new Dimension(15, 15));
        this.btnFast.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                NanoGong.this.btnFastActionPerformed(actionEvent);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        this.panSpeed.add((Component)this.btnFast, gridBagConstraints);
        this.lblSpeed.setFont(new Font("Dialog", 0, 10));
        this.lblSpeed.setHorizontalAlignment(0);
        this.lblSpeed.setText("x1.0");
        this.lblSpeed.setMaximumSize(new Dimension(30, 10));
        this.lblSpeed.setMinimumSize(new Dimension(30, 10));
        this.lblSpeed.setPreferredSize(new Dimension(30, 10));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridwidth = 2;
        this.panSpeed.add((Component)this.lblSpeed, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridy = 0;
        gridBagConstraints.insets = new Insets(0, 5, 0, 0);
        this.panPanel.add((Component)this.panSpeed, gridBagConstraints);
        this.btnSave.setToolTipText(this.bundle.getString("TOOLTIP_SAVE_BUTTON"));
        this.btnSave.setMaximumSize(new Dimension(25, 25));
        this.btnSave.setMinimumSize(new Dimension(25, 25));
        this.btnSave.setPreferredSize(new Dimension(25, 25));
        this.btnSave.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                NanoGong.this.btnSaveActionPerformed(actionEvent);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridy = 0;
        gridBagConstraints.insets = new Insets(0, 5, 0, 0);
        this.panPanel.add((Component)this.btnSave, gridBagConstraints);
        this.slrTime.setValue(0);
        this.slrTime.setMaximumSize(new Dimension(Short.MAX_VALUE, 4));
        this.slrTime.setMinimumSize(new Dimension(4, 4));
        this.slrTime.setPreferredSize(new Dimension(4, 4));
        this.slrTime.addMouseListener(new MouseAdapter(){

            public void mouseEntered(MouseEvent mouseEvent) {
                NanoGong.this.slrTimeMouseEntered(mouseEvent);
            }

            public void mouseExited(MouseEvent mouseEvent) {
                NanoGong.this.slrTimeMouseExited(mouseEvent);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(5, 0, 0, 0);
        this.panPanel.add((Component)this.slrTime, gridBagConstraints);
        this.getContentPane().add(this.panPanel);
        this.panWait.setLayout(new BoxLayout(this.panWait, 1));
        this.panWait.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        this.lblMessage.setFont(new Font("Dialog", 0, 10));
        this.lblMessage.setHorizontalAlignment(0);
        this.lblMessage.setAlignmentX(0.5f);
        this.lblMessage.setMaximumSize(new Dimension(32768, 32768));
        this.panWait.add(this.lblMessage);
        this.pbrWait.setForeground(new Color(64, 64, 255));
        this.pbrWait.setIndeterminate(true);
        this.pbrWait.setMaximumSize(new Dimension(Short.MAX_VALUE, 5));
        this.pbrWait.setMinimumSize(new Dimension(10, 5));
        this.pbrWait.setPreferredSize(new Dimension(100, 5));
        this.panWait.add(this.pbrWait);
        this.getContentPane().add(this.panWait);
    }

    private void slrTimeMouseExited(MouseEvent mouseEvent) {
        if (this.showTime) {
            this.panGlassPane.setVisible(false);
        }
    }

    private void slrTimeMouseEntered(MouseEvent mouseEvent) {
        if (this.showTime) {
            this.panGlassPane.setVisible(true);
        }
    }

    private void btnSaveActionPerformed(ActionEvent actionEvent) {
        ScriptHandler scriptHandler = this.getScriptHandler("SaveMessage", new String[0]);
        if (scriptHandler == null) {
            JOptionPane.showMessageDialog(this, "NanoGong is busy at the moment.", "Error", 0);
            return;
        }
        scriptHandler.execute();
        Object object = scriptHandler.getFault();
        if (object != null) {
            JOptionPane.showMessageDialog(this, object.toString(), "Error", 0);
        }
        this.clearScriptHandler();
    }

    private void setRate(float f) {
        if (f < 0.5f) {
            f = 0.5f;
        } else if (f > 1.5f) {
            f = 1.5f;
        }
        f = (float)((int)(f * 10.0f)) / 10.0f;
        this.lblSpeed.setText("x" + f);
        this.handler.setRate(f);
    }

    private void btnFastActionPerformed(ActionEvent actionEvent) {
        this.setRate(this.handler.getRate() + 0.1f);
    }

    private void btnSlowActionPerformed(ActionEvent actionEvent) {
        this.setRate(this.handler.getRate() - 0.1f);
    }

    private void btnStopActionPerformed(ActionEvent actionEvent) {
        ScriptHandler scriptHandler = this.getScriptHandler("StopMedia", new String[0]);
        if (scriptHandler == null) {
            JOptionPane.showMessageDialog(this, "NanoGong is busy at the moment.", "Error", 0);
            return;
        }
        scriptHandler.execute();
        Object object = scriptHandler.getFault();
        if (object != null) {
            JOptionPane.showMessageDialog(this, object.toString(), "Error", 0);
        }
        this.clearScriptHandler();
    }

    private void btnRecordActionPerformed(ActionEvent actionEvent) {
        ScriptHandler scriptHandler = this.handler.getStatus() == 1 ? this.getScriptHandler("PauseMedia", new String[0]) : this.getScriptHandler("RecordMedia", new String[]{"audio", String.valueOf(this.maxDuration)});
        if (scriptHandler == null) {
            JOptionPane.showMessageDialog(this, "NanoGong is busy at the moment.", "Error", 0);
            return;
        }
        scriptHandler.execute();
        Object object = scriptHandler.getFault();
        if (object != null) {
            JOptionPane.showMessageDialog(this, object.toString(), "Error", 0);
        }
        this.clearScriptHandler();
    }

    private void btnPlayActionPerformed(ActionEvent actionEvent) {
        String[] stringArray;
        ScriptHandler scriptHandler;
        if (this.handler.getStatus() == 2) {
            scriptHandler = this.getScriptHandler("PauseMedia", new String[0]);
        } else {
            stringArray = this.endTime >= 0L ? new String[]{"audio", String.valueOf(this.handler.getTime()), String.valueOf(this.endTime)} : new String[]{"audio", String.valueOf(this.handler.getTime())};
            scriptHandler = this.getScriptHandler("PlayMedia", stringArray);
        }
        if (scriptHandler == null) {
            JOptionPane.showMessageDialog(this, "NanoGong is busy at the moment.", "Error", 0);
            return;
        }
        scriptHandler.execute();
        stringArray = scriptHandler.getFault();
        if (stringArray != null) {
            JOptionPane.showMessageDialog(this, stringArray.toString(), "Error", 0);
        }
        this.clearScriptHandler();
    }

    private class ScriptHandler
    extends gong.xml.gasi.ScriptHandler {
        public ScriptHandler(String string) {
            super(string);
        }

        public ScriptHandler(String string, String[] stringArray) {
            super(string, stringArray);
        }

        protected void playMedia() throws Exception {
            long l;
            long l2;
            if (NanoGong.this.handler.getStatus() != 4 && NanoGong.this.handler.getStatus() != 7) {
                throw new Exception("You are not allowed to play a message at the moment.");
            }
            String string = this.getParameter("StartTime", 1);
            try {
                l2 = Long.parseLong(string);
            }
            catch (NumberFormatException numberFormatException) {
                l2 = NanoGong.this.handler.getTime();
            }
            string = this.getParameter("EndTime", 2);
            try {
                l = Long.parseLong(string);
            }
            catch (NumberFormatException numberFormatException) {
                l = 0L;
            }
            if (l > 0L && l > l2) {
                NanoGong.this.handler.play(l2, l);
            } else {
                NanoGong.this.handler.play(l2);
            }
            if (this.isXML()) {
                Response response = Response.newResponse("PlayMediaResponse");
                response.setParameter("StartTime", String.valueOf(l2), false);
                response.setParameter("EndTime", String.valueOf(l), false);
                this.setResponse(response);
            } else {
                this.setResponse(String.valueOf(l2) + ";" + String.valueOf(l));
            }
        }

        protected void recordMedia() throws Exception {
            long l;
            if (NanoGong.this.handler.getStatus() != 5 && NanoGong.this.handler.getStatus() != 9 && NanoGong.this.handler.getStatus() != 7) {
                throw new Exception("You are not allowed to record a message at the moment.");
            }
            String string = this.getParameter("Duration", 1);
            try {
                l = Long.parseLong(string);
            }
            catch (NumberFormatException numberFormatException) {
                l = 300000L;
            }
            NanoGong.this.handler.setDuration(l);
            AudioFormat audioFormat = new AudioFormat(NanoGong.this.samplingRate, 16, 1, true, true);
            NanoGong.this.handler.setDataFormat(audioFormat);
            if (NanoGong.this.audioFormat.equals(NanoGong.IMA_ADPCM)) {
                NanoGong.this.handler.setRecordData(new ImaADPCMData(audioFormat));
            } else {
                NanoGong.this.handler.setRecordData(new SpeexData(audioFormat, true, NanoGong.this.speexQuality));
            }
            NanoGong.this.handler.record(l);
            NanoGong.this.modified = true;
            if (this.isXML()) {
                Response response = Response.newResponse("RecordMediaResponse");
                response.setParameter("Duration", String.valueOf(l), false);
                this.setResponse(response);
            } else {
                this.setResponse(String.valueOf(l));
            }
        }

        protected void pauseMedia() throws Exception {
            if (NanoGong.this.handler.getStatus() != 2 && NanoGong.this.handler.getStatus() != 1) {
                throw new Exception("You are not allowed to pause a playback or recording at the moment.");
            }
            NanoGong.this.handler.pause();
            if (this.isXML()) {
                Response response = Response.newResponse("PauseMediaResponse");
                response.setParameter("Time", String.valueOf(NanoGong.this.handler.getTime()), false);
                this.setResponse(response);
            } else {
                this.setResponse(String.valueOf(NanoGong.this.handler.getTime()));
            }
        }

        protected void stopMedia() throws Exception {
            boolean bl;
            boolean bl2 = bl = NanoGong.this.handler.getStatus() == 1 || NanoGong.this.handler.getStatus() == 5;
            if (NanoGong.this.handler.getStatus() != 2 && NanoGong.this.handler.getStatus() != 1 && NanoGong.this.handler.getStatus() != 4 && NanoGong.this.handler.getStatus() != 5) {
                throw new Exception("You are not allowed to stop a playback or recording at the moment.");
            }
            NanoGong.this.handler.stop();
            long l = 0L;
            if (bl) {
                l = NanoGong.this.handler.getDuration();
            }
            if (this.isXML()) {
                Response response = Response.newResponse("StopMediaResponse");
                if (l > 0L) {
                    response.setParameter("Duration", String.valueOf(l), false);
                }
                this.setResponse(response);
            } else {
                this.setResponse(l > 0L ? String.valueOf(l) : "");
            }
        }

        protected void clearMedia() throws Exception {
            if (NanoGong.this.handler.getStatus() != 7 && NanoGong.this.handler.getStatus() != 9) {
                throw new Exception("You are not allowed to clear a recording at the moment.");
            }
            NanoGong.this.handler.stop();
            NanoGong.this.handler.setData(null);
            NanoGong.this.handler.setURL(null);
            if (this.isXML()) {
                this.setResponse(Response.newResponse("ClearMediaResponse"));
            } else {
                this.setResponse("");
            }
        }

        protected void setMediaTime() throws Exception {
            long l;
            if (!NanoGong.this.handler.hasData()) {
                throw new Exception("There is no voice recording at the moment.");
            }
            String string = this.getParameter("Time", 1);
            try {
                l = Long.parseLong(string);
                if (l < 0L || l > NanoGong.this.handler.getDuration()) {
                    throw new Exception("The time is not within the duration of the recording.");
                }
            }
            catch (NumberFormatException numberFormatException) {
                throw new Exception("A valid time value must be provided.");
            }
            NanoGong.this.handler.setTime(l);
            if (this.isXML()) {
                Response response = Response.newResponse("SetMediaTimeResponse");
                response.setParameter("Time", String.valueOf(l), false);
                this.setResponse(response);
            } else {
                this.setResponse(String.valueOf(l));
            }
        }

        protected void getMediaTime() throws Exception {
            if (!NanoGong.this.handler.hasData()) {
                throw new Exception("There is no voice recording at the moment.");
            }
            long l = NanoGong.this.handler.getTime();
            if (this.isXML()) {
                Response response = Response.newResponse("GetMediaTimeResponse");
                response.setParameter("Time", String.valueOf(l), false);
                this.setResponse(response);
            } else {
                this.setResponse(String.valueOf(l));
            }
        }

        protected void getMediaDuration() throws Exception {
            if (!NanoGong.this.handler.hasData()) {
                throw new Exception("There is no voice recording at the moment.");
            }
            long l = NanoGong.this.handler.getDuration();
            if (this.isXML()) {
                Response response = Response.newResponse("GetMediaDurationResponse");
                response.setParameter("Duration", String.valueOf(l), false);
                this.setResponse(response);
            } else {
                this.setResponse(String.valueOf(l));
            }
        }

        protected void setMediaRate() throws Exception {
            float f;
            String string = this.getParameter("Rate", 1);
            try {
                f = Float.parseFloat(string);
                if (f < 0.5f || f > 1.5f) {
                    throw new Exception("The rate must be within 0.5 to 1.5.");
                }
            }
            catch (NumberFormatException numberFormatException) {
                throw new Exception("The valid rate value must be provided.");
            }
            NanoGong.this.setRate(f);
            if (this.isXML()) {
                Response response = Response.newResponse("SetMediaRateResponse");
                response.setParameter("Rate", String.valueOf(f), false);
                this.setResponse(response);
            } else {
                this.setResponse(String.valueOf(f));
            }
        }

        protected void getMediaRate() throws Exception {
            float f = NanoGong.this.handler.getRate();
            if (this.isXML()) {
                Response response = Response.newResponse("GetMediaRateResponse");
                response.setParameter("Rate", String.valueOf(f), false);
                this.setResponse(response);
            } else {
                this.setResponse(String.valueOf(f));
            }
        }

        protected void getMediaStatus() throws Exception {
            String string = "unknown";
            if (NanoGong.this.handler.getStatus() == 2) {
                string = "playing";
            } else if (NanoGong.this.handler.getStatus() == 1) {
                string = "recording";
            } else if (NanoGong.this.handler.getStatus() == 4) {
                string = "paused";
            } else if (NanoGong.this.handler.getStatus() == 5) {
                string = "paused recording";
            } else if (NanoGong.this.handler.getStatus() == 6) {
                string = "stopping";
            } else if (NanoGong.this.handler.getStatus() == 7) {
                string = "stopped";
            } else if (NanoGong.this.handler.getStatus() == 8) {
                string = "closing";
            } else if (NanoGong.this.handler.getStatus() == 9) {
                string = "closed";
            }
            if (this.isXML()) {
                Response response = Response.newResponse("GetMediaStatusResponse");
                response.setParameter("Status", string, false);
                this.setResponse(response);
            } else {
                this.setResponse(string);
            }
        }

        protected void getAudioLevel() throws Exception {
            float f = NanoGong.this.handler.getAmplitude();
            String string = new DecimalFormat("0.00").format(f);
            if (this.isXML()) {
                Response response = Response.newResponse("GetAudioLevelResponse");
                response.setParameter("Level", string, false);
                this.setResponse(response);
            } else {
                this.setResponse(string);
            }
        }

        protected void movePrevMessage() throws Exception {
            throw new Exception("Script function not implemented.");
        }

        protected void moveNextMessage() throws Exception {
            throw new Exception("Script function not implemented.");
        }

        protected void selectMessage() throws Exception {
            throw new Exception("Script function not implemented.");
        }

        protected void getCurrentMessageId() throws Exception {
            throw new Exception("Script function not implemented.");
        }

        protected void searchMessage() throws Exception {
            throw new Exception("Script function not implemented.");
        }

        protected void getMessage() throws Exception {
            throw new Exception("Script function not implemented.");
        }

        protected void getMessageContent() throws Exception {
            throw new Exception("Script function not implemented.");
        }

        protected void postMessage() throws Exception {
            throw new Exception("Script function not implemented.");
        }

        protected File saveMessage(String string, String string2, String string3) throws Exception {
            Object[] objectArray;
            int n;
            float f = NanoGong.this.handler.getRate();
            if (f != 1.0f && (n = JOptionPane.showOptionDialog(NanoGong.this, "You have changed the playback speed of the recording.\nDo you want to save the recording in its original speed or the adjusted speed?", "Question", 0, 3, null, objectArray = new Object[]{"The original speed", "The adjusted speed"}, objectArray[1])) == 0) {
                f = 1.0f;
            }
            objectArray = new File(string, string2);
            NanoGong.this.handler.downloadData(null, true);
            AudioData audioData = NanoGong.this.handler.getData();
            BlockAudioData blockAudioData = null;
            if (string3.equals("wav/adpcm")) {
                blockAudioData = new ImaADPCMData(audioData.getFormat());
            } else if (string3.equals("speex")) {
                if (NanoGong.this.speexQuality == 0) {
                    NanoGong.this.speexQuality = 10;
                }
                blockAudioData = new SpeexData(audioData.getFormat(), true, NanoGong.this.speexQuality);
            } else if (string3.equals("flv/pcm")) {
                blockAudioData = new FlvPCMData(audioData.getFormat());
            } else {
                throw new Exception("Invalid file format.");
            }
            OlaBuffer olaBuffer = new OlaBuffer(audioData.getFormat(), f);
            audioData.reset();
            while (audioData.isAvailable()) {
                olaBuffer.write(audioData.read());
                while (olaBuffer.isAvailable()) {
                    ((AudioData)blockAudioData).write(olaBuffer.read());
                }
            }
            olaBuffer.drain();
            while (olaBuffer.isAvailable()) {
                ((AudioData)blockAudioData).write(olaBuffer.read());
            }
            FileOutputStream fileOutputStream = new FileOutputStream((File)objectArray);
            blockAudioData.sendToStream(fileOutputStream);
            fileOutputStream.close();
            return objectArray;
        }

        protected void saveMessageWithPrompt(final String string, final String string2) {
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    try {
                        FileFilter fileFilter = new FileFilter(){

                            public boolean accept(File file) {
                                if (file.isDirectory()) {
                                    return true;
                                }
                                String string = file.getName().toLowerCase();
                                return string.endsWith(".wav");
                            }

                            public String getDescription() {
                                return "Compressed WAV format (.wav)";
                            }
                        };
                        FileFilter fileFilter2 = new FileFilter(){

                            public boolean accept(File file) {
                                if (file.isDirectory()) {
                                    return true;
                                }
                                String string = file.getName().toLowerCase();
                                return string.endsWith(".spx");
                            }

                            public String getDescription() {
                                return "Speex format (.spx)";
                            }
                        };
                        FileFilter fileFilter3 = new FileFilter(){

                            public boolean accept(File file) {
                                if (file.isDirectory()) {
                                    return true;
                                }
                                String string = file.getName().toLowerCase();
                                return string.endsWith(".flv");
                            }

                            public String getDescription() {
                                return "Raw FLV format (.flv)";
                            }
                        };
                        JFileChooser jFileChooser = null;
                        jFileChooser = string2 == null ? new JFileChooser() : new JFileChooser(new File(string2));
                        jFileChooser.setAcceptAllFileFilterUsed(false);
                        if (string != null && string.equals("wav/adpcm")) {
                            jFileChooser.addChoosableFileFilter(fileFilter);
                            jFileChooser.setFileFilter(fileFilter);
                        } else if (string != null && string.equals("speex")) {
                            jFileChooser.addChoosableFileFilter(fileFilter2);
                            jFileChooser.setFileFilter(fileFilter2);
                        } else if (string != null && string.equals("flv/pcm")) {
                            jFileChooser.addChoosableFileFilter(fileFilter3);
                            jFileChooser.setFileFilter(fileFilter3);
                        } else {
                            jFileChooser.addChoosableFileFilter(fileFilter);
                            jFileChooser.addChoosableFileFilter(fileFilter2);
                            jFileChooser.addChoosableFileFilter(fileFilter3);
                            jFileChooser.setFileFilter(fileFilter);
                        }
                        int n = jFileChooser.showSaveDialog(NanoGong.this);
                        if (n == 0) {
                            String string4 = ".wav";
                            String string22 = "wav/adpcm";
                            if (jFileChooser.getFileFilter().equals(fileFilter2)) {
                                string4 = ".spx";
                                string22 = "speex";
                            } else if (jFileChooser.getFileFilter().equals(fileFilter3)) {
                                string4 = ".flv";
                                string22 = "flv/pcm";
                            }
                            String string3 = jFileChooser.getSelectedFile().getName();
                            if (!string3.endsWith(string4)) {
                                string3 = string3 + string4;
                            }
                            ScriptHandler.this.saveMessage(jFileChooser.getSelectedFile().getParent(), string3, string22);
                        }
                    }
                    catch (Exception exception) {
                        JOptionPane.showMessageDialog(NanoGong.this, exception.getMessage(), "Error", 0);
                    }
                }
            });
        }

        protected void saveMessage() throws Exception {
            if (!NanoGong.this.handler.hasData()) {
                throw new Exception("There is nothing available at the moment.");
            }
            String string = this.getParameter("Type", 0);
            String string2 = this.getParameter("Filename", 1);
            String string3 = this.getParameter("Path", 2);
            if (string2 == null || string2.length() == 0) {
                this.saveMessageWithPrompt(string, string3);
                if (this.isXML()) {
                    this.setResponse(Response.newResponse("SaveMessageResponse"));
                } else {
                    this.setResponse("");
                }
                return;
            }
            if (string == null || !string.equals("wav/adpcm") && !string.equals("speex") && !string.equals("flv/pcm")) {
                throw new Exception("You must specify the requested file type.");
            }
            File file = this.saveMessage(string3, string2, string);
            if (this.isXML()) {
                Response response = Response.newResponse("SaveMessageResponse");
                response.setParameter("File", file.getAbsolutePath(), false);
                this.setResponse(response);
            } else {
                this.setResponse(file.getAbsolutePath());
            }
        }

        protected void postToForm() throws Exception {
            Object object;
            String string;
            String string2;
            Object object2;
            CharSequence charSequence;
            NanoGong.this.handler.stop();
            if (!NanoGong.this.handler.hasData()) {
                throw new Exception("There is nothing available at the moment.");
            }
            String string3 = this.getParameter("URL", 0);
            String string4 = this.getParameter("Parameter", 1);
            String string5 = this.getParameter("Cookies", 2);
            String string6 = this.getParameter("Filename", 3);
            if (string3 == null || string3.trim().length() == 0) {
                throw new Exception("You must provide a valid url.");
            }
            if (string4 == null || string4.trim().length() == 0) {
                throw new Exception("You must provide a parameter name for the message.");
            }
            if (string6 == null || string6.trim().length() == 0) {
                throw new Exception("You must provide a filename.");
            }
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    NanoGong.this.panPanel.setVisible(false);
                    NanoGong.this.lblMessage.setText(NanoGong.this.getMessageString("MESSAGE_CONNECTING"));
                    NanoGong.this.pbrWait.setIndeterminate(true);
                    NanoGong.this.panWait.setVisible(true);
                }
            });
            URLConnection uRLConnection = null;
            try {
                charSequence = "";
                int n = string6.length();
                if (n > 4) {
                    charSequence = string6.substring(n - 4, n);
                }
                if (!((String)charSequence).equalsIgnoreCase(NanoGong.this.handler.getData().getFileExtension())) {
                    string6 = string6 + NanoGong.this.handler.getData().getFileExtension();
                }
                object2 = null;
                try {
                    object2 = MessageDigest.getInstance("MD5");
                }
                catch (NoSuchAlgorithmException noSuchAlgorithmException) {
                    throw new Exception("Failed to create the request boundary.");
                }
                string2 = String.valueOf(new Date().getTime());
                ((MessageDigest)object2).update(string2.getBytes(), 0, string2.length());
                string = new BigInteger(1, ((MessageDigest)object2).digest()).toString(16);
                try {
                    uRLConnection = new URL(NanoGong.this.resolveURL(string3)).openConnection();
                    uRLConnection.setDoOutput(true);
                    uRLConnection.setRequestProperty("Content-Type", "multipart/form-data; boundary=" + string);
                }
                catch (MalformedURLException malformedURLException) {
                    throw new Exception("URL is not a valid URL.");
                }
                catch (IOException iOException) {
                    throw new Exception("Failed to open the URL.");
                }
                catch (Exception exception) {
                    throw new Exception("Unknown error.");
                }
            }
            catch (Exception exception) {
                SwingUtilities.invokeLater(new Runnable(){

                    public void run() {
                        NanoGong.this.panPanel.setVisible(true);
                        NanoGong.this.panWait.setVisible(false);
                    }
                });
                throw exception;
            }
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    NanoGong.this.lblMessage.setText(NanoGong.this.getMessageString("MESSAGE_SENDING"));
                }
            });
            charSequence = new StringBuffer();
            try {
                if (string5 != null && string5.length() > 0) {
                    uRLConnection.setRequestProperty("Cookie", string5);
                }
                object = uRLConnection.getOutputStream();
                ((OutputStream)object).write(("--" + string + "\r\n").getBytes());
                ((OutputStream)object).write(("Content-Disposition: form-data; name=\"" + string4 + "\"; filename=\"" + string6 + "\"\r\n").getBytes());
                ((OutputStream)object).write("Content-Type: application/octet-stream\r\n\r\n".getBytes());
                NanoGong.this.handler.downloadData(null, true);
                NanoGong.this.handler.getData().setListener(NanoGong.this);
                NanoGong.this.handler.getData().sendToStream((OutputStream)object);
                NanoGong.this.handler.getData().setListener(null);
                ((OutputStream)object).write("\r\n".getBytes());
                ((OutputStream)object).write(("--" + string + "--").getBytes());
                ((OutputStream)object).close();
                try {
                    object2 = new BufferedReader(new InputStreamReader(uRLConnection.getInputStream()));
                    while ((string2 = ((BufferedReader)object2).readLine()) != null) {
                        ((StringBuffer)charSequence).append(string2);
                    }
                    ((BufferedReader)object2).close();
                }
                catch (IOException iOException) {
                    throw new Exception("Failed to connect to the destination.");
                }
            }
            catch (Exception exception) {
                try {
                    throw exception;
                }
                catch (Throwable throwable) {
                    SwingUtilities.invokeLater(new Runnable(){

                        public void run() {
                            NanoGong.this.panPanel.setVisible(true);
                            NanoGong.this.panWait.setVisible(false);
                        }
                    });
                    throw throwable;
                }
            }
            SwingUtilities.invokeLater(new /* invalid duplicate definition of identical inner class */);
            if (this.isXML()) {
                object = Response.newResponse("PostToFormResponse");
                ((Message)object).setParameter("Return", ((StringBuffer)charSequence).toString(), false);
                this.setResponse(object);
            } else {
                this.setResponse(((StringBuffer)charSequence).toString());
            }
        }

        protected void loadFromURL() throws Exception {
            NanoGong.this.handler.stop();
            String string = this.getParameter("URL", 0);
            String string2 = this.getParameter("Start", 1);
            if (string == null || string.trim().length() == 0) {
                throw new Exception("You must provide a valid url.");
            }
            try {
                string = NanoGong.this.resolveURL(string);
                NanoGong.this.handler.setURL(string);
                NanoGong.this.modified = false;
            }
            catch (MalformedURLException malformedURLException) {
                throw new Exception("You must provide a valid url.");
            }
            URLLoader uRLLoader = NanoGong.this.getURLLoader(string, 0L, 0L);
            if (uRLLoader == null) {
                throw new Exception("NanoGong is busy at the moment.");
            }
            uRLLoader.start();
            NanoGong.this.modified = true;
            if (this.isXML()) {
                Response response = Response.newResponse("LoadFromURLResponse");
                response.setParameter("URL", string, false);
                this.setResponse(response);
            } else {
                this.setResponse(string);
            }
        }

        protected void getCurrentToken() throws Exception {
            throw new Exception("Script function not implemented.");
        }

        protected void getBoardName() throws Exception {
            throw new Exception("Script function not implemented.");
        }

        protected void getBoardData() throws Exception {
            throw new Exception("Script function not implemented.");
        }

        protected void getVersion() throws Exception {
            if (this.isXML()) {
                Response response = Response.newResponse("GetVersionResponse");
                response.setParameter("Version", NanoGong.VERSION_NUMBER, false);
                this.setResponse(response);
            } else {
                this.setResponse(NanoGong.VERSION_NUMBER);
            }
        }
    }

    private class URLLoader
    extends Thread {
        private String url;
        private long startTime;
        private long endTime;

        public URLLoader(String string, long l, long l2) {
            this.url = string;
            this.startTime = l;
            this.endTime = l2;
        }

        public void run() {
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    NanoGong.this.panPanel.setVisible(false);
                    NanoGong.this.lblMessage.setText(NanoGong.this.getMessageString("MESSAGE_LOADING"));
                    NanoGong.this.pbrWait.setIndeterminate(true);
                    NanoGong.this.panWait.setVisible(true);
                }
            });
            try {
                NanoGong.this.handler.setData(null);
                NanoGong.this.handler.downloadData(null, true, NanoGong.this);
                NanoGong.this.handler.getData().setListener(null);
                if (this.startTime > 0L && this.startTime < NanoGong.this.handler.getDuration() || this.endTime > 0L && this.endTime < NanoGong.this.handler.getDuration()) {
                    AudioData audioData = NanoGong.this.handler.getData();
                    BlockAudioData blockAudioData = NanoGong.this.audioFormat.equals(NanoGong.IMA_ADPCM) ? new ImaADPCMData(audioData.getFormat()) : new SpeexData(audioData.getFormat(), true, NanoGong.this.speexQuality);
                    audioData.reset();
                    if (this.startTime > 0L) {
                        audioData.setTime(this.startTime);
                    }
                    while (audioData.isAvailable()) {
                        ((AudioData)blockAudioData).write(audioData.read());
                        if (this.endTime <= 0L || audioData.getTime() <= this.endTime) continue;
                    }
                    NanoGong.this.handler.setData(blockAudioData);
                }
            }
            catch (Exception exception) {
                JOptionPane.showMessageDialog(NanoGong.this, exception.getMessage(), "Error", 0);
                NanoGong.this.handler.setURL(null);
            }
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    NanoGong.this.panPanel.setVisible(true);
                    NanoGong.this.panWait.setVisible(false);
                }
            });
            NanoGong.this.clearURLLoader();
        }
    }
}

