/*
 * Decompiled with CFR 0.152.
 */
package gong;

import gong.xml.GongDomObject;
import java.awt.Color;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.StringReader;
import java.io.StringWriter;
import java.security.MessageDigest;
import java.text.DecimalFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;
import javax.crypto.Cipher;
import javax.crypto.SecretKey;
import javax.crypto.SecretKeyFactory;
import javax.crypto.spec.DESKeySpec;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;
import sun.misc.BASE64Decoder;
import sun.misc.BASE64Encoder;

public class Utility {
    private static DocumentBuilderFactory builderFactory = null;
    private static TransformerFactory transformerFactory = null;

    public static Document parseXMLDocument(String string) throws Exception {
        if (builderFactory == null) {
            builderFactory = GongDomObject.createDocumentBuilderFactory();
        }
        DocumentBuilder documentBuilder = builderFactory.newDocumentBuilder();
        StringReader stringReader = new StringReader(string);
        InputSource inputSource = new InputSource(stringReader);
        Document document = documentBuilder.parse(inputSource);
        Utility.normalize(document);
        return document;
    }

    public static Document parseXMLDocument(File file) throws Exception {
        if (builderFactory == null) {
            builderFactory = GongDomObject.createDocumentBuilderFactory();
        }
        DocumentBuilder documentBuilder = builderFactory.newDocumentBuilder();
        BufferedInputStream bufferedInputStream = new BufferedInputStream(new FileInputStream(file));
        InputSource inputSource = new InputSource(bufferedInputStream);
        Document document = documentBuilder.parse(inputSource);
        Utility.normalize(document);
        return document;
    }

    public static Document getNewDocument() throws Exception {
        if (builderFactory == null) {
            builderFactory = GongDomObject.createDocumentBuilderFactory();
        }
        DocumentBuilder documentBuilder = builderFactory.newDocumentBuilder();
        return documentBuilder.newDocument();
    }

    protected static void normalize(Node node) {
        Object object;
        Node node2;
        int n;
        NodeList nodeList = node.getChildNodes();
        for (n = 0; n < nodeList.getLength() - 1; ++n) {
            node2 = nodeList.item(n);
            if (node2.getNodeType() != 3) continue;
            ++n;
            while (n < nodeList.getLength() && (object = nodeList.item(n)).getNodeType() == 3) {
                String string = node2.getNodeValue() + object.getNodeValue();
                node2.setNodeValue(string);
                node.removeChild((Node)object);
                ++n;
            }
        }
        nodeList = node.getChildNodes();
        for (n = 0; n < nodeList.getLength(); ++n) {
            node2 = nodeList.item(n);
            if (node2.getNodeType() == 3) {
                object = node2.getNodeValue();
                if (((String)object).trim().length() != 0) continue;
                node.removeChild(node2);
                --n;
                continue;
            }
            Utility.normalize(node2);
        }
    }

    public static String serializeXMLDocument(Document document, boolean bl) throws Exception {
        StringWriter stringWriter = new StringWriter();
        if (transformerFactory == null) {
            transformerFactory = GongDomObject.createTransformerFactory();
        }
        Transformer transformer = transformerFactory.newTransformer();
        DOMSource dOMSource = new DOMSource(document);
        StreamResult streamResult = new StreamResult(stringWriter);
        if (bl) {
            transformer.setOutputProperty("indent", "yes");
            transformer.setOutputProperty("{http://xml.apache.org/xalan}indent-amount", "2");
        } else {
            transformer.setOutputProperty("indent", "no");
        }
        transformer.setOutputProperty("encoding", "utf-8");
        transformer.transform(dOMSource, streamResult);
        stringWriter.close();
        return stringWriter.toString();
    }

    public static void serializeXMLDocument(Document document, boolean bl, File file) throws Exception {
        FileOutputStream fileOutputStream = new FileOutputStream(file);
        if (transformerFactory == null) {
            transformerFactory = GongDomObject.createTransformerFactory();
        }
        Transformer transformer = transformerFactory.newTransformer();
        DOMSource dOMSource = new DOMSource(document);
        StreamResult streamResult = new StreamResult(fileOutputStream);
        if (bl) {
            transformer.setOutputProperty("indent", "yes");
            transformer.setOutputProperty("{http://xml.apache.org/xalan}indent-amount", "2");
        } else {
            transformer.setOutputProperty("indent", "no");
        }
        transformer.setOutputProperty("encoding", "utf-8");
        transformer.transform(dOMSource, streamResult);
        fileOutputStream.close();
    }

    public static Element createXMLElement(Document document, String string, String string2, boolean bl) {
        Element element = document.createElement(string);
        if (string2 != null && string2.length() > 0) {
            if (bl) {
                element.appendChild(document.createCDATASection(string2));
            } else {
                element.appendChild(document.createTextNode(string2));
            }
        }
        return element;
    }

    public static String getXMLAttribute(Element element, String string) {
        String string2 = element.getAttribute(string);
        if (string2 == null) {
            return "";
        }
        return string2.trim();
    }

    public static String getXMLText(Element element) {
        String string = "";
        NodeList nodeList = element.getChildNodes();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Node node = nodeList.item(i);
            string = node.getNodeType() == 3 ? string + node.getNodeValue() : string + Utility.getXMLText((Element)node);
        }
        return string;
    }

    public static String escapeHTML(String string) {
        if (string == null) {
            return "";
        }
        String string2 = string;
        try {
            string2 = string2.replaceAll("&", "&amp;");
            string2 = string2.replaceAll("\"", "&quot;");
            string2 = string2.replaceAll("'", "&apos;");
            string2 = string2.replaceAll("<", "&lt;");
            string2 = string2.replaceAll(">", "&gt;");
            string2 = string2.replaceAll("&apos;", "'");
        }
        catch (Exception exception) {
            return string2;
        }
        return string2;
    }

    public static String formatDate(Date date, String string) {
        return new SimpleDateFormat(string, Locale.US).format(date);
    }

    public static String formatTime(long l, boolean bl) {
        double d = (double)l / 1000.0;
        int n = (int)d;
        int n2 = (int)((d - (double)n) * 1000.0);
        int n3 = n / 60;
        n %= 60;
        int n4 = n3 / 60;
        n3 %= 60;
        String string = "";
        DecimalFormat decimalFormat = new DecimalFormat("00");
        if (n4 > 0) {
            string = string + decimalFormat.format(n4) + ":";
        }
        string = string + decimalFormat.format(n3) + ":" + decimalFormat.format(n);
        if (bl) {
            decimalFormat = new DecimalFormat("000");
            string = string + "." + decimalFormat.format(n2);
        }
        return string;
    }

    public static String encrypt(String string, String string2) {
        try {
            MessageDigest messageDigest = MessageDigest.getInstance("MD5");
            messageDigest.reset();
            messageDigest.update(string.getBytes("utf-8"));
            messageDigest.update(string2.getBytes("utf-8"));
            return messageDigest.toString();
        }
        catch (Exception exception) {
            return "";
        }
    }

    public static String encodeURL(String string) {
        String string2 = "";
        String string3 = " \"<>#%{}|\\^~[]`";
        for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            if (c >= '\u0000' && c <= '\u001f' || c >= '\u007f' && c <= '\u00ff' || string3.indexOf(c) != -1) {
                String string4 = Integer.toHexString(c);
                if (string4.length() == 1) {
                    string4 = "0" + string4;
                }
                string2 = string2 + "%" + string4;
                continue;
            }
            string2 = string2 + c;
        }
        return string2;
    }

    public static String encryptString(String string, String string2, String string3) throws Exception {
        while (string2.length() < 8) {
            string2 = string2 + "0";
        }
        DESKeySpec dESKeySpec = new DESKeySpec(string2.getBytes());
        SecretKey secretKey = SecretKeyFactory.getInstance(string3).generateSecret(dESKeySpec);
        Cipher cipher = Cipher.getInstance(secretKey.getAlgorithm());
        cipher.init(1, secretKey);
        byte[] byArray = cipher.doFinal(string.getBytes("utf-8"));
        return new BASE64Encoder().encode(byArray);
    }

    public static String decryptString(String string, String string2, String string3) throws Exception {
        while (string2.length() < 8) {
            string2 = string2 + "0";
        }
        DESKeySpec dESKeySpec = new DESKeySpec(string2.getBytes());
        SecretKey secretKey = SecretKeyFactory.getInstance(string3).generateSecret(dESKeySpec);
        Cipher cipher = Cipher.getInstance(secretKey.getAlgorithm());
        cipher.init(2, secretKey);
        byte[] byArray = new BASE64Decoder().decodeBuffer(string);
        byte[] byArray2 = cipher.doFinal(byArray);
        return new String(byArray2, "utf-8");
    }

    public static String colorToRGB(Color color) {
        if (color == null) {
            return "000000";
        }
        return Integer.toHexString(color.getRGB()).substring(2);
    }

    public static Color rgbToColor(String string) {
        try {
            return new Color(Integer.parseInt(string, 16) | 0xFF000000);
        }
        catch (Throwable throwable) {
            return Color.BLACK;
        }
    }
}

