/*
 * Decompiled with CFR 0.152.
 */
package gong.xml.gasi;

import gong.xml.gasi.Message;
import gong.xml.gasi.Request;
import java.security.AccessController;
import java.security.PrivilegedAction;

public abstract class ScriptHandler {
    protected static final String DELIMITER = ";";
    protected static final String MIME_TEXT_PLAIN = "text/plain";
    protected static final String MIME_TEXT_HTML = "text/html";
    protected static final String TYPE_WAV_ADPCM = "wav/adpcm";
    protected static final String TYPE_SPEEX = "speex";
    protected static final String TYPE_FLV_PCM = "flv/pcm";
    private Request request = null;
    private String name = null;
    private String[] params = null;
    private Object response = null;
    private Object fault = null;

    public ScriptHandler(String string) {
        try {
            Message message = Message.parse(string);
            if (message == null || !message.getClass().equals(Request.class)) {
                throw new Exception();
            }
            this.request = (Request)message;
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public ScriptHandler(String string, String[] stringArray) {
        this.name = string;
        this.params = stringArray;
    }

    protected boolean isXML() {
        return this.request != null;
    }

    protected void setResponse(Object object) {
        this.response = object;
    }

    public Object getResponse() {
        return this.response;
    }

    protected void setFault(String string) {
        if (this.isXML()) {
            try {
                this.fault = Message.newFault("", string);
            }
            catch (Throwable throwable) {}
        } else {
            this.fault = string;
        }
    }

    public Object getFault() {
        return this.fault;
    }

    private String getRequestName() {
        if (this.isXML()) {
            return this.request.getName();
        }
        return this.name == null ? "" : this.name + "Request";
    }

    protected String getParameter(String string, int n, int n2) throws Exception {
        if (this.isXML()) {
            return this.request.getParameter(string);
        }
        try {
            String string2 = this.params[n];
            if (n2 < 0) {
                return string2;
            }
            String[] stringArray = string2.split(DELIMITER);
            return stringArray[n2];
        }
        catch (Exception exception) {
            return null;
        }
    }

    protected String getParameter(String string, int n) throws Exception {
        return this.getParameter(string, n, -1);
    }

    protected String getParameter(String string, String string2, int n, int n2) throws Exception {
        if (this.isXML()) {
            return this.request.getParameter(string, string2);
        }
        return this.getParameter(null, n, n2);
    }

    protected void executeRequest() {
        block29: {
            try {
                String string = this.getRequestName();
                if (string.equals("PlayMediaRequest")) {
                    this.playMedia();
                    break block29;
                }
                if (string.equals("RecordMediaRequest")) {
                    this.recordMedia();
                    break block29;
                }
                if (string.equals("PauseMediaRequest")) {
                    this.pauseMedia();
                    break block29;
                }
                if (string.equals("StopMediaRequest")) {
                    this.stopMedia();
                    break block29;
                }
                if (string.equals("ClearMediaRequest")) {
                    this.clearMedia();
                    break block29;
                }
                if (string.equals("SetMediaTimeRequest")) {
                    this.setMediaTime();
                    break block29;
                }
                if (string.equals("GetMediaTimeRequest")) {
                    this.getMediaTime();
                    break block29;
                }
                if (string.equals("GetMediaDurationRequest")) {
                    this.getMediaDuration();
                    break block29;
                }
                if (string.equals("SetMediaRateRequest")) {
                    this.setMediaRate();
                    break block29;
                }
                if (string.equals("GetMediaRateRequest")) {
                    this.getMediaRate();
                    break block29;
                }
                if (string.equals("GetMediaStatusRequest")) {
                    this.getMediaStatus();
                    break block29;
                }
                if (string.equals("GetAudioLevelRequest")) {
                    this.getAudioLevel();
                    break block29;
                }
                if (string.equals("GetCurrentMessageIdRequest")) {
                    this.getCurrentMessageId();
                    break block29;
                }
                if (string.equals("SearchMessageRequest")) {
                    this.searchMessage();
                    break block29;
                }
                if (string.equals("GetMessageRequest")) {
                    this.getMessage();
                    break block29;
                }
                if (string.equals("GetMessageContentRequest")) {
                    this.getMessageContent();
                    break block29;
                }
                if (string.equals("MoveToPrevMessageRequest")) {
                    this.movePrevMessage();
                    break block29;
                }
                if (string.equals("MoveToNextMessageRequest")) {
                    this.moveNextMessage();
                    break block29;
                }
                if (string.equals("SelectMessageRequest")) {
                    this.selectMessage();
                    break block29;
                }
                if (string.equals("PostMessageRequest")) {
                    this.postMessage();
                    break block29;
                }
                if (string.equals("SaveMessageRequest")) {
                    this.saveMessage();
                    break block29;
                }
                if (string.equals("PostToFormRequest")) {
                    this.postToForm();
                    break block29;
                }
                if (string.equals("LoadFromURLRequest")) {
                    this.loadFromURL();
                    break block29;
                }
                if (string.equals("GetCurrentTokenRequest")) {
                    this.getCurrentToken();
                    break block29;
                }
                if (string.equals("GetBoardNameRequest")) {
                    this.getBoardName();
                    break block29;
                }
                if (string.equals("GetBoardDataRequest")) {
                    this.getBoardData();
                    break block29;
                }
                if (string.equals("GetVersionRequest")) {
                    this.getVersion();
                    break block29;
                }
                throw new Exception("You have made an invalid request.");
            }
            catch (Exception exception) {
                this.setFault(exception.getMessage());
            }
        }
    }

    public void execute() {
        AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                ScriptHandler.this.executeRequest();
                return null;
            }
        });
    }

    protected abstract void playMedia() throws Exception;

    protected abstract void recordMedia() throws Exception;

    protected abstract void pauseMedia() throws Exception;

    protected abstract void stopMedia() throws Exception;

    protected abstract void clearMedia() throws Exception;

    protected abstract void setMediaTime() throws Exception;

    protected abstract void getMediaTime() throws Exception;

    protected abstract void getMediaDuration() throws Exception;

    protected abstract void setMediaRate() throws Exception;

    protected abstract void getMediaRate() throws Exception;

    protected abstract void getMediaStatus() throws Exception;

    protected abstract void getAudioLevel() throws Exception;

    protected abstract void movePrevMessage() throws Exception;

    protected abstract void moveNextMessage() throws Exception;

    protected abstract void selectMessage() throws Exception;

    protected abstract void getCurrentMessageId() throws Exception;

    protected abstract void searchMessage() throws Exception;

    protected abstract void getMessage() throws Exception;

    protected abstract void getMessageContent() throws Exception;

    protected abstract void postMessage() throws Exception;

    protected abstract void saveMessage() throws Exception;

    protected abstract void postToForm() throws Exception;

    protected abstract void loadFromURL() throws Exception;

    protected abstract void getCurrentToken() throws Exception;

    protected abstract void getBoardName() throws Exception;

    protected abstract void getBoardData() throws Exception;

    protected abstract void getVersion() throws Exception;
}

