/*
 * Decompiled with CFR 0.152.
 */
package com.flagstone.transform.fillstyle;

import com.flagstone.transform.coder.CoderException;
import com.flagstone.transform.coder.Context;
import com.flagstone.transform.coder.SWFDecoder;
import com.flagstone.transform.coder.SWFFactory;
import com.flagstone.transform.fillstyle.BitmapFill;
import com.flagstone.transform.fillstyle.FillStyle;
import com.flagstone.transform.fillstyle.FocalGradientFill;
import com.flagstone.transform.fillstyle.GradientFill;
import com.flagstone.transform.fillstyle.SolidFill;
import java.io.IOException;
import java.util.List;

public final class FillStyleDecoder
implements SWFFactory<FillStyle> {
    @Override
    public void getObject(List<FillStyle> list, SWFDecoder coder, Context context) throws IOException {
        FillStyle style;
        int type = coder.readByte();
        switch (type) {
            case 0: {
                style = new SolidFill(coder, context);
                break;
            }
            case 16: {
                style = new GradientFill(type, coder, context);
                break;
            }
            case 18: {
                style = new GradientFill(type, coder, context);
                break;
            }
            case 19: {
                style = new FocalGradientFill(coder, context);
                break;
            }
            case 64: {
                style = new BitmapFill(type, coder);
                break;
            }
            case 65: {
                style = new BitmapFill(type, coder);
                break;
            }
            case 66: {
                style = new BitmapFill(type, coder);
                break;
            }
            case 67: {
                style = new BitmapFill(type, coder);
                break;
            }
            default: {
                throw new CoderException(coder.mark(), "Unsupported FillStyle: " + type);
            }
        }
        list.add(style);
    }
}

