/*
 * Decompiled with CFR 0.152.
 */
package com.hammurapi.jcapture;

import com.hammurapi.jcapture.CaptureFrame;
import com.hammurapi.jcapture.Movie;
import com.hammurapi.jcapture.MovieEditorDialog;
import com.hammurapi.jcapture.ScreenRecorder;
import java.applet.Applet;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.SwingWorker;
import javax.swing.border.LineBorder;
import netscape.javascript.JSObject;
import org.apache.http.HttpResponse;

public class RecordingControlsFrame
extends JFrame {
    private static final String RESUME_TEXT = "Resume";
    private static final String PAUSE_TEXT = "Pause";
    private JButton pauseButton;
    private JButton cancelButton;
    private JButton stopButton;
    private ScreenRecorder screenRecorder;
    private CaptureFrame captureFrame;

    public RecordingControlsFrame(final CaptureFrame captureFrame, final JFrame[] borderFrames) {
        super("jCapture recording");
        this.setIconImage(captureFrame.getIconImage());
        this.captureFrame = captureFrame;
        this.setUndecorated(true);
        this.setAlwaysOnTop(!this.getBounds().intersects(captureFrame.getBounds()));
        this.addComponentListener(new ComponentListener(){

            @Override
            public void componentShown(ComponentEvent e) {
                for (JFrame bf : borderFrames) {
                    if (bf == null) continue;
                    bf.setVisible(true);
                }
            }

            @Override
            public void componentResized(ComponentEvent e) {
            }

            @Override
            public void componentMoved(ComponentEvent e) {
            }

            @Override
            public void componentHidden(ComponentEvent e) {
                for (JFrame bf : borderFrames) {
                    if (bf == null) continue;
                    bf.setVisible(false);
                }
            }
        });
        JPanel contentPanel = new JPanel();
        contentPanel.setBorder(new LineBorder(new Color(0, 0, 0), 1, false));
        this.getContentPane().add((Component)contentPanel, "Center");
        GridBagLayout thisLayout = new GridBagLayout();
        this.setDefaultCloseOperation(2);
        thisLayout.rowWeights = new double[]{0.0, 0.1, 0.0};
        thisLayout.rowHeights = new int[]{7, 7, 7};
        thisLayout.columnWeights = new double[]{0.0, 0.1, 0.0, 0.1, 0.0, 0.1, 0.0};
        thisLayout.columnWidths = new int[]{7, 20, 7, 20, 7, 7, 7};
        contentPanel.setLayout(thisLayout);
        this.pauseButton = new JButton();
        contentPanel.add((Component)this.pauseButton, new GridBagConstraints(1, 1, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.pauseButton.setText(PAUSE_TEXT);
        this.pauseButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                try {
                    if (RecordingControlsFrame.PAUSE_TEXT.equals(RecordingControlsFrame.this.pauseButton.getText())) {
                        RecordingControlsFrame.this.screenRecorder.stop();
                        RecordingControlsFrame.this.pauseButton.setText(RecordingControlsFrame.RESUME_TEXT);
                    } else {
                        RecordingControlsFrame.this.screenRecorder.start();
                        RecordingControlsFrame.this.pauseButton.setText(RecordingControlsFrame.PAUSE_TEXT);
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                    JOptionPane.showMessageDialog(RecordingControlsFrame.this, e.toString(), "Error pausing/resuming recording", 0);
                }
            }
        });
        this.stopButton = new JButton();
        contentPanel.add((Component)this.stopButton, new GridBagConstraints(3, 1, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.stopButton.setText("Stop");
        this.stopButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                RecordingControlsFrame.this.pauseButton.setEnabled(false);
                RecordingControlsFrame.this.stopButton.setEnabled(false);
                RecordingControlsFrame.this.cancelButton.setEnabled(false);
                SwingWorker<Movie, Long> task = new SwingWorker<Movie, Long>(){

                    @Override
                    protected Movie doInBackground() throws Exception {
                        RecordingControlsFrame.this.screenRecorder.stop();
                        return RecordingControlsFrame.this.screenRecorder.getMovie();
                    }

                    @Override
                    protected void done() {
                        try {
                            Movie movie = (Movie)this.get();
                            if (movie != null) {
                                if (JOptionPane.showConfirmDialog(RecordingControlsFrame.this, "Would you like to edit the movie before uploading?", "Edit movie?", 0) == 0) {
                                    new MovieEditorDialog(RecordingControlsFrame.this, movie, captureFrame.getCaptureConfig().getBackgroundProcessor(), captureFrame.getCaptureConfig().getInactivityInterval(), captureFrame.getCaptureConfig().getImageFormat());
                                } else {
                                    RecordingControlsFrame.this.uploadMovie(movie);
                                }
                            } else {
                                JOptionPane.showMessageDialog(RecordingControlsFrame.this, "Recording discarded", "Saving recording", 1);
                                RecordingControlsFrame.this.setVisible(false);
                            }
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                            JOptionPane.showMessageDialog(RecordingControlsFrame.this, e.toString(), "Error saving recording", 0);
                            RecordingControlsFrame.this.setVisible(false);
                        }
                    }
                };
                task.execute();
            }
        });
        this.cancelButton = new JButton();
        contentPanel.add((Component)this.cancelButton, new GridBagConstraints(5, 1, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.cancelButton.setText("Cancel");
        this.cancelButton.addActionListener(new ActionListener(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void actionPerformed(ActionEvent evt) {
                if (JOptionPane.showConfirmDialog(RecordingControlsFrame.this, "Are you sure you want to discard the recording?", "Confirm discarding movie", 0) == 0) {
                    try {
                        RecordingControlsFrame.this.screenRecorder.stop();
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                        JOptionPane.showMessageDialog(RecordingControlsFrame.this, e.toString(), "Error cancelling recording", 0);
                    }
                    finally {
                        RecordingControlsFrame.this.setVisible(false);
                        captureFrame.setVisible(true);
                    }
                }
            }
        });
        this.pack();
        this.setSize(301, 40);
        captureFrame.getCaptureConfig().setParentComponent(this);
        try {
            this.screenRecorder = new ScreenRecorder(captureFrame.getCaptureConfig(), captureFrame.getApplet());
        }
        catch (Exception e) {
            e.printStackTrace();
            JOptionPane.showMessageDialog(this, e.toString(), "Error starting recording", 0);
            this.setVisible(false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void uploadMovie(final Movie movie) {
        try {
            if (movie != null) {
                final String fileName = JOptionPane.showInputDialog(this, "Upload as", this.captureFrame.getApplet().getParameter("pageName") + "-recording-" + this.captureFrame.getDatePrefix() + "-" + this.captureFrame.nextCounter() + "." + this.captureFrame.getCaptureConfig().getEncoder().getFileExtension());
                if (fileName != null) {
                    SwingWorker<Dimension, Long> task = new SwingWorker<Dimension, Long>(){
                        private Object errorMessage;
                        private String errorTitle;

                        @Override
                        protected Dimension doInBackground() throws Exception {
                            File savedTo = null;
                            try {
                                File tmpFile = File.createTempFile("jCaptureMovie", "." + RecordingControlsFrame.this.captureFrame.getCaptureConfig().getEncoder().getFileExtension());
                                FileOutputStream out = new FileOutputStream(tmpFile);
                                Dimension dimension = RecordingControlsFrame.this.captureFrame.getCaptureConfig().getEncoder().encode(RecordingControlsFrame.this.captureFrame.getCaptureConfig(), movie, out);
                                if (dimension == null) {
                                    return null;
                                }
                                out.close();
                                savedTo = tmpFile;
                                HttpResponse iResponse = RecordingControlsFrame.this.captureFrame.getApplet().post(RecordingControlsFrame.this, new FileInputStream(tmpFile), tmpFile.length(), fileName, "application/octet-stream");
                                if (iResponse != null) {
                                    System.out.println("Response status line: " + iResponse.getStatusLine());
                                    if (iResponse.getStatusLine().getStatusCode() != 200) {
                                        this.errorMessage = iResponse.getStatusLine();
                                        this.errorTitle = "Error saving recording";
                                        return null;
                                    }
                                }
                                if (!tmpFile.delete()) {
                                    tmpFile.deleteOnExit();
                                }
                                return dimension;
                            }
                            catch (Error e) {
                                this.errorMessage = e.toString();
                                if (savedTo != null) {
                                    this.errorMessage = this.errorMessage + ",\n recording was saved to " + savedTo.getAbsolutePath();
                                }
                                this.errorTitle = "Upload error";
                                e.printStackTrace();
                                return null;
                            }
                        }

                        @Override
                        protected void done() {
                            try {
                                Dimension dimension = (Dimension)this.get();
                                if (dimension != null) {
                                    JSObject window = JSObject.getWindow((Applet)RecordingControlsFrame.this.captureFrame.getApplet());
                                    String toEval = "insertAtCarret('" + RecordingControlsFrame.this.captureFrame.getApplet().getParameter("edid") + "','{{:" + fileName + "?" + dimension.width + "x" + dimension.height + "|}}')";
                                    System.out.println("Evaluating: " + toEval);
                                    window.eval(toEval);
                                } else {
                                    JOptionPane.showMessageDialog(RecordingControlsFrame.this, this.errorMessage, this.errorTitle, 0);
                                }
                            }
                            catch (Exception e) {
                                e.printStackTrace();
                                JOptionPane.showMessageDialog(RecordingControlsFrame.this, e.toString(), "Exception", 0);
                            }
                        }
                    };
                    task.execute();
                }
            } else {
                JOptionPane.showMessageDialog(this, "Recording discarded", "Saving recording", 1);
            }
        }
        finally {
            this.setVisible(false);
        }
    }
}

