<?php
/* For licensing terms, see /license.txt */
/**
 * Glossay class definition
 * @package chamilo.glossary
 */
/**
 * Init
 */

namespace Glossary;


/**
 * Glossary entry. Model for database access
 * 
 * @license see /license.txt
 * @author autogenerated
 */
class Glossary extends \Entity
{
    /**
     * @return \Glossary\GlossaryRepository
     */
     public static function repository(){
        return GlossaryRepository::instance();
    }

    /**
     * @return \Glossary\Glossary
     */
     public static function create($data = null){
        return new self($data);
    }

    /**
     * @var integer $c_id
     */
    protected $c_id;

    /**
     * @var integer $glossary_id
     */
    protected $glossary_id;

    /**
     * @var string $name
     */
    protected $name;

    /**
     * @var text $description
     */
    protected $description;

    /**
     * @var integer $display_order
     */
    protected $display_order;

    /**
     * @var integer $session_id
     */
    protected $session_id;

    /**
     * Set c_id
     *
     * @param integer $value
     * @return Glossary
     */
    public function set_c_id($value)
    {
        $this->c_id = $value;
        return $this;
    }

    /**
     * The course id
     *
     * @return integer 
     */
    public function get_c_id()
    {
        return $this->c_id;
    }

    /**
     * Set glossary entry id
     *
     * @param integer $value
     * @return Glossary
     */
    public function set_glossary_id($value)
    {
        $this->glossary_id = $value;
        return $this;
    }

    /**
     * Get glossary_id
     *
     * @return integer 
     */
    public function get_glossary_id()
    {
        return $this->glossary_id;
    }
    
    /**
     * Alias for glossary id. Better to use the same naming convention
     * for all classes.
     *
     * @return integer 
     */
    public function get_id()
    {
        return $this->glossary_id;
    }

    /**
     * Set glossary_id
     *
     * @param integer $value
     * @return Glossary
     */
    public function set_id($value)
    {
        $this->glossary_id = $value;
        return $this;
    }
    
    /**
     * Set name
     *
     * @param string $value
     * @return Glossary
     */
    public function set_name($value)
    {
        $this->name = $value;
        return $this;
    }

    /**
     * The name/title of the glossary entry
     *
     * @return string 
     */
    public function get_name()
    {
        return $this->name;
    }

    /**
     * Set description
     *
     * @param text $value
     * @return Glossary
     */
    public function set_description($value)
    {
        $this->description = $value;
        return $this;
    }

    /**
     * The description/definition of the glossary entry
     *
     * @return text 
     */
    public function get_description()
    {
        return $this->description;
    }

    /**
     * Set display_order
     *
     * @param integer $value
     * @return Glossary
     */
    public function set_display_order($value)
    {
        $this->display_order = $value;
        return $this;
    }

    /**
     * The display order. Not used.
     *
     * @return integer 
     */
    public function get_display_order()
    {
        return $this->display_order;
    }

    /**
     * Set session_id
     *
     * @param integer $value
     * @return Glossary
     */
    public function set_session_id($value)
    {
        $this->session_id = $value;
        return $this;
    }

    /**
     * The session id.
     *
     * @return integer 
     */
    public function get_session_id()
    {
        return $this->session_id;
    }
}
