<?php
/* For licensing terms, see /license.txt */

/**
 *	This script displays an area where teachers can edit the group properties and member list.
 *	Groups are also often called "teams" in the Dokeos code.
 *
 *	@author various contributors
 *	@author Roan Embrechts (VUB), partial code cleanup, initial virtual course support
 *	@package chamilo.group
 *	@todo course admin functionality to create groups based on who is in which course (or class).
 */

/*	INIT SECTION */

// Name of the language file that needs to be included
$language_file = 'group';

require_once '../inc/global.inc.php';
$this_section = SECTION_COURSES;
$current_course_tool  = TOOL_GROUP;

// Notice for unauthorized people.
api_protect_course_script(true);

$group_id = api_get_group_id();
$current_group = GroupManager::get_group_properties($group_id);

$nameTools = get_lang('EditGroup');
$interbreadcrumb[] = array('url' => 'group.php', 'name' => get_lang('Groups'));
$interbreadcrumb[] = array('url' => 'group_space.php?'.api_get_cidReq(), 'name' => $current_group['name']);

$is_group_member = GroupManager::is_tutor_of_group(api_get_user_id(), $group_id);

if (!api_is_allowed_to_edit(false, true) && !$is_group_member) {
    api_not_allowed(true);
}

/**
 *  List all users registered to the course
 */
function search_members_keyword($firstname, $lastname, $username, $official_code, $keyword)
{
    if (api_strripos($firstname, $keyword) !== false ||
        api_strripos($lastname, $keyword) !== false ||
        api_strripos($username, $keyword) !== false ||
        api_strripos($official_code, $keyword) !== false
    ) {
        return true;
    } else {
        return false;
    }
}

/**
 * Function to sort users after getting the list in the DB.
 * Necessary because there are 2 or 3 queries. Called by usort()
 */
function sort_users($user_a, $user_b)
{
    global $_configuration;
    if (isset($_configuration['order_user_list_by_official_code']) &&
        $_configuration['order_user_list_by_official_code']
    ) {
        $cmp = api_strcmp($user_a['official_code'], $user_b['official_code']);
        if ($cmp !== 0) {
            return $cmp;
        } else {
            $cmp = api_strcmp($user_a['lastname'], $user_b['lastname']);
            if ($cmp !== 0) {
                return $cmp;
            } else {
                return api_strcmp($user_a['username'], $user_b['username']);
            }
        }
    }

    if (api_sort_by_first_name()) {
        $cmp = api_strcmp($user_a['firstname'], $user_b['firstname']);
        if ($cmp !== 0) {
            return $cmp;
        } else {
            $cmp = api_strcmp($user_a['lastname'], $user_b['lastname']);
            if ($cmp !== 0) {
                return $cmp;
            } else {
                return api_strcmp($user_a['username'], $user_b['username']);
            }
        }
    } else {
        $cmp = api_strcmp($user_a['lastname'], $user_b['lastname']);
        if ($cmp !== 0) {
            return $cmp;
        } else {
            $cmp = api_strcmp($user_a['firstname'], $user_b['firstname']);
            if ($cmp !== 0) {
                return $cmp;
            } else {
                return api_strcmp($user_a['username'], $user_b['username']);
            }
        }
    }
}

/**
 * Function to check if the number of selected group members is valid
 */
function check_group_members($value)
{
    if ($value['max_student'] == GroupManager::MEMBER_PER_GROUP_NO_LIMIT) {
        return true;
    }
    if (isset($value['max_student']) && isset($value['group_members']) && $value['max_student'] < count($value['group_members'])) {
        return array('group_members' => get_lang('GroupTooMuchMembers'));
    }

    return true;
}

/*	MAIN CODE */

$htmlHeadXtra[] = '<script>
$(document).ready( function() {
    $("#max_member").on("focus", function() {
        $("#max_member_selected").attr("checked", true);
    });
});
 </script>';

// Build form
$form = new FormValidator('group_edit', 'post', api_get_self().'?'.api_get_cidreq());
$form->addElement('hidden', 'action');
$form->addElement('hidden', 'max_student', $current_group['max_student']);
$complete_user_list = GroupManager::fill_groups_list($current_group['id']);

$possible_users = array();
if (!empty($complete_user_list)) {
    usort($complete_user_list, 'sort_users');
    foreach ($complete_user_list as $index => $user) {
        $officialCode = !empty($user['official_code']) ? ' - '.$user['official_code'] : null;

        $name = api_get_person_name(
                $user['firstname'],
                $user['lastname']
                ).' ('.$user['username'].')'.$officialCode;

        global $_configuration;
        if (isset($_configuration['order_user_list_by_official_code']) &&
            $_configuration['order_user_list_by_official_code']
        ) {
            $officialCode = !empty($user['official_code']) ? $user['official_code']." - " : '? - ';
            $name = $officialCode." ".api_get_person_name(
                $user['firstname'],
                $user['lastname']
            ).' ('.$user['username'].')';
        }
        $possible_users[$user['user_id']] = $name;
    }
}

// Group members
$group_member_list = GroupManager::get_subscribed_users($current_group['id']);

$selected_users = array ();
if (!empty($group_member_list)) {
    foreach ($group_member_list as $index => $user) {
        $selected_users[] = $user['user_id'];
    }
}
$group_members_element = $form->addElement(
    'advmultiselect',
    'group_members',
    get_lang('GroupMembers'),
    $possible_users,
    'style="width: 280px;"'
);

$group_members_element->setElementTemplate('
{javascript}
<table{class}>
<!-- BEGIN label_2 --><tr><th>{label_2}</th><!-- END label_2 -->
<!-- BEGIN label_3 --><th>&nbsp;</th><th>{label_3}</th></tr><!-- END label_3 -->
<tr>
  <td valign="top">{unselected}</td>
  <td align="center">{add}<br /><br />{remove}</td>
  <td valign="top">{selected}</td>
</tr>
</table>');

$group_members_element->setButtonAttributes('add', array('class' => 'btn arrowr'));
$group_members_element->setButtonAttributes('remove', array('class' => 'btn arrowl'));
$form->addFormRule('check_group_members');

// submit button
$form->addElement('style_submit_button', 'submit', get_lang('SaveSettings'), 'class="save"');

if ($form->validate()) {
    $values = $form->exportValues();

    // Storing the users (we first remove all users and then add only those who were selected)
    GroupManager :: unsubscribe_all_users($current_group['id']);
    if (isset ($_POST['group_members']) && count($_POST['group_members']) > 0) {
        GroupManager :: subscribe_users($values['group_members'], $current_group['id']);
    }

    // Returning to the group area (note: this is inconsistent with the rest of chamilo)
    $cat = GroupManager :: get_category_from_group($current_group['id']);
    if (isset($_POST['group_members']) && count($_POST['group_members']) > $max_member && $max_member != GroupManager::MEMBER_PER_GROUP_NO_LIMIT) {
        header('Location: group.php?'.api_get_cidreq(true, false).'&action=warning_message&msg='.get_lang('GroupTooMuchMembers'));
    } else {
        header('Location: group.php?'.api_get_cidreq(true, false).'&action=success_message&msg='.get_lang('GroupSettingsModified').'&category='.$cat['id']);
    }
    exit;
}

$action = isset($_GET['action']) ? $_GET['action'] : null;
switch ($action) {
    case 'empty':
        if (api_is_allowed_to_edit(false, true)) {
            GroupManager :: unsubscribe_all_users($group_id);
            Display :: display_confirmation_message(get_lang('GroupEmptied'));
        }
        break;
}

$defaults = $current_group;
$defaults['group_members'] = $selected_users;
$action = isset($_GET['action']) ? $_GET['action'] : '';
$defaults['action'] = $action;

if (!empty($_GET['keyword']) && !empty($_GET['submit'])) {
    $keyword_name = Security::remove_XSS($_GET['keyword']);
    echo '<br/>'.get_lang('SearchResultsFor').' <span style="font-style: italic ;"> '.$keyword_name.' </span><br>';
}

Display::display_header($nameTools, 'Group');

//@todo fix this
if (isset($_GET['show_message_warning'])) {
    echo Display::display_warning_message($_GET['show_message_warning']);
}

if (isset($_GET['show_message_sucess'])) {
    echo Display::display_normal_message($_GET['show_message_sucess']);
}

$form->setDefaults($defaults);
echo GroupManager::getSettingBar('member');

$form->display();

Display :: display_footer();
