<?php

namespace Entity;

use Doctrine\ORM\Mapping as ORM;

/**
 *
 * @license see /license.txt
 * @author autogenerated
 */
class Course extends \Entity
{
    /**
     * @return \Entity\Repository\CourseRepository
     */
     public static function repository(){
        return \Entity\Repository\CourseRepository::instance();
    }

    /**
     * @return \Entity\Course
     */
     public static function create(){
        return new self();
    }

    /**
     * @var integer $id
     */
    protected $id;

    /**
     * @var string $code
     */
    protected $code;

    /**
     * @var string $directory
     */
    protected $directory;

    /**
     * @var string $db_name
     */
    protected $db_name;

    /**
     * @var string $course_language
     */
    protected $course_language;

    /**
     * @var string $title
     */
    protected $title;

    /**
     * @var text $description
     */
    protected $description;

    /**
     * @var string $category_code
     */
    protected $category_code;

    /**
     * @var boolean $visibility
     */
    protected $visibility;

    /**
     * @var integer $show_score
     */
    protected $show_score;

    /**
     * @var string $tutor_name
     */
    protected $tutor_name;

    /**
     * @var string $visual_code
     */
    protected $visual_code;

    /**
     * @var string $department_name
     */
    protected $department_name;

    /**
     * @var string $department_url
     */
    protected $department_url;

    /**
     * @var bigint $disk_quota
     */
    protected $disk_quota;

    /**
     * @var datetime $last_visit
     */
    protected $last_visit;

    /**
     * @var datetime $last_edit
     */
    protected $last_edit;

    /**
     * @var datetime $creation_date
     */
    protected $creation_date;

    /**
     * @var datetime $expiration_date
     */
    protected $expiration_date;

    /**
     * @var string $target_course_code
     */
    protected $target_course_code;

    /**
     * @var boolean $subscribe
     */
    protected $subscribe;

    /**
     * @var boolean $unsubscribe
     */
    protected $unsubscribe;

    /**
     * @var string $registration_code
     */
    protected $registration_code;

    /**
     * @var text $legal
     */
    protected $legal;

    /**
     * @var integer $activate_legal
     */
    protected $activate_legal;

    /**
     * @var integer $course_type_id
     */
    protected $course_type_id;


    /**
     * Get id
     *
     * @return integer 
     */
    public function get_id()
    {
        return $this->id;
    }

    /**
     * Set code
     *
     * @param string $value
     * @return Course
     */
    public function set_code($value)
    {
        $this->code = $value;
        return $this;
    }

    /**
     * Get code
     *
     * @return string 
     */
    public function get_code()
    {
        return $this->code;
    }

    /**
     * Set directory
     *
     * @param string $value
     * @return Course
     */
    public function set_directory($value)
    {
        $this->directory = $value;
        return $this;
    }

    /**
     * Get directory
     *
     * @return string 
     */
    public function get_directory()
    {
        return $this->directory;
    }

    /**
     * Set db_name
     *
     * @param string $value
     * @return Course
     */
    public function set_db_name($value)
    {
        $this->db_name = $value;
        return $this;
    }

    /**
     * Get db_name
     *
     * @return string 
     */
    public function get_db_name()
    {
        return $this->db_name;
    }

    /**
     * Set course_language
     *
     * @param string $value
     * @return Course
     */
    public function set_course_language($value)
    {
        $this->course_language = $value;
        return $this;
    }

    /**
     * Get course_language
     *
     * @return string 
     */
    public function get_course_language()
    {
        return $this->course_language;
    }

    /**
     * Set title
     *
     * @param string $value
     * @return Course
     */
    public function set_title($value)
    {
        $this->title = $value;
        return $this;
    }

    /**
     * Get title
     *
     * @return string 
     */
    public function get_title()
    {
        return $this->title;
    }

    /**
     * Set description
     *
     * @param text $value
     * @return Course
     */
    public function set_description($value)
    {
        $this->description = $value;
        return $this;
    }

    /**
     * Get description
     *
     * @return text 
     */
    public function get_description()
    {
        return $this->description;
    }

    /**
     * Set category_code
     *
     * @param string $value
     * @return Course
     */
    public function set_category_code($value)
    {
        $this->category_code = $value;
        return $this;
    }

    /**
     * Get category_code
     *
     * @return string 
     */
    public function get_category_code()
    {
        return $this->category_code;
    }

    /**
     * Set visibility
     *
     * @param boolean $value
     * @return Course
     */
    public function set_visibility($value)
    {
        $this->visibility = $value;
        return $this;
    }

    /**
     * Get visibility
     *
     * @return boolean 
     */
    public function get_visibility()
    {
        return $this->visibility;
    }

    /**
     * Set show_score
     *
     * @param integer $value
     * @return Course
     */
    public function set_show_score($value)
    {
        $this->show_score = $value;
        return $this;
    }

    /**
     * Get show_score
     *
     * @return integer 
     */
    public function get_show_score()
    {
        return $this->show_score;
    }

    /**
     * Set tutor_name
     *
     * @param string $value
     * @return Course
     */
    public function set_tutor_name($value)
    {
        $this->tutor_name = $value;
        return $this;
    }

    /**
     * Get tutor_name
     *
     * @return string 
     */
    public function get_tutor_name()
    {
        return $this->tutor_name;
    }

    /**
     * Set visual_code
     *
     * @param string $value
     * @return Course
     */
    public function set_visual_code($value)
    {
        $this->visual_code = $value;
        return $this;
    }

    /**
     * Get visual_code
     *
     * @return string 
     */
    public function get_visual_code()
    {
        return $this->visual_code;
    }

    /**
     * Set department_name
     *
     * @param string $value
     * @return Course
     */
    public function set_department_name($value)
    {
        $this->department_name = $value;
        return $this;
    }

    /**
     * Get department_name
     *
     * @return string 
     */
    public function get_department_name()
    {
        return $this->department_name;
    }

    /**
     * Set department_url
     *
     * @param string $value
     * @return Course
     */
    public function set_department_url($value)
    {
        $this->department_url = $value;
        return $this;
    }

    /**
     * Get department_url
     *
     * @return string 
     */
    public function get_department_url()
    {
        return $this->department_url;
    }

    /**
     * Set disk_quota
     *
     * @param bigint $value
     * @return Course
     */
    public function set_disk_quota($value)
    {
        $this->disk_quota = $value;
        return $this;
    }

    /**
     * Get disk_quota
     *
     * @return bigint 
     */
    public function get_disk_quota()
    {
        return $this->disk_quota;
    }

    /**
     * Set last_visit
     *
     * @param datetime $value
     * @return Course
     */
    public function set_last_visit($value)
    {
        $this->last_visit = $value;
        return $this;
    }

    /**
     * Get last_visit
     *
     * @return datetime 
     */
    public function get_last_visit()
    {
        return $this->last_visit;
    }

    /**
     * Set last_edit
     *
     * @param datetime $value
     * @return Course
     */
    public function set_last_edit($value)
    {
        $this->last_edit = $value;
        return $this;
    }

    /**
     * Get last_edit
     *
     * @return datetime 
     */
    public function get_last_edit()
    {
        return $this->last_edit;
    }

    /**
     * Set creation_date
     *
     * @param datetime $value
     * @return Course
     */
    public function set_creation_date($value)
    {
        $this->creation_date = $value;
        return $this;
    }

    /**
     * Get creation_date
     *
     * @return datetime 
     */
    public function get_creation_date()
    {
        return $this->creation_date;
    }

    /**
     * Set expiration_date
     *
     * @param datetime $value
     * @return Course
     */
    public function set_expiration_date($value)
    {
        $this->expiration_date = $value;
        return $this;
    }

    /**
     * Get expiration_date
     *
     * @return datetime 
     */
    public function get_expiration_date()
    {
        return $this->expiration_date;
    }

    /**
     * Set target_course_code
     *
     * @param string $value
     * @return Course
     */
    public function set_target_course_code($value)
    {
        $this->target_course_code = $value;
        return $this;
    }

    /**
     * Get target_course_code
     *
     * @return string 
     */
    public function get_target_course_code()
    {
        return $this->target_course_code;
    }

    /**
     * Set subscribe
     *
     * @param boolean $value
     * @return Course
     */
    public function set_subscribe($value)
    {
        $this->subscribe = $value;
        return $this;
    }

    /**
     * Get subscribe
     *
     * @return boolean 
     */
    public function get_subscribe()
    {
        return $this->subscribe;
    }

    /**
     * Set unsubscribe
     *
     * @param boolean $value
     * @return Course
     */
    public function set_unsubscribe($value)
    {
        $this->unsubscribe = $value;
        return $this;
    }

    /**
     * Get unsubscribe
     *
     * @return boolean 
     */
    public function get_unsubscribe()
    {
        return $this->unsubscribe;
    }

    /**
     * Set registration_code
     *
     * @param string $value
     * @return Course
     */
    public function set_registration_code($value)
    {
        $this->registration_code = $value;
        return $this;
    }

    /**
     * Get registration_code
     *
     * @return string 
     */
    public function get_registration_code()
    {
        return $this->registration_code;
    }

    /**
     * Set legal
     *
     * @param text $value
     * @return Course
     */
    public function set_legal($value)
    {
        $this->legal = $value;
        return $this;
    }

    /**
     * Get legal
     *
     * @return text 
     */
    public function get_legal()
    {
        return $this->legal;
    }

    /**
     * Set activate_legal
     *
     * @param integer $value
     * @return Course
     */
    public function set_activate_legal($value)
    {
        $this->activate_legal = $value;
        return $this;
    }

    /**
     * Get activate_legal
     *
     * @return integer 
     */
    public function get_activate_legal()
    {
        return $this->activate_legal;
    }

    /**
     * Set course_type_id
     *
     * @param integer $value
     * @return Course
     */
    public function set_course_type_id($value)
    {
        $this->course_type_id = $value;
        return $this;
    }

    /**
     * Get course_type_id
     *
     * @return integer 
     */
    public function get_course_type_id()
    {
        return $this->course_type_id;
    }
}